function [x, l] = shapetothicknesses( shape )
% function [x, l] = shapetothicknesses( shape )
% 
% gets the lengths of lines in a shapefile, only the euclidean distance between the
% first and last point of each line segment is calculated. x is the average
% x coordinate

sl = length( shape );

l = zeros(sl, 1);
x = zeros(sl, 1);

for idx = 1 : sl,
    X = shape(idx).X;
    Y = shape(idx).Y;
    
    p1 = [X(1), Y(1)];
    p2 = [X(end-1), Y(end-1)];
    
    l(idx) = sqrt(sum((p2-p1).^2));
    pav = 0.5*(p1 + p2);
    x(idx) = pav(1);
end;
    
    

